/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.palette.VWDraggablePaletteItemUI;
import filenet.vw.toolkit.design.palette.VWPaletteMenuItem;
import filenet.vw.toolkit.design.palette.VWStepPaletteDocumentHelper;
import filenet.vw.toolkit.design.palette.VWStepPaletteItemUI;
import filenet.vw.toolkit.design.palette.VWStepPalettePanel;
import filenet.vw.toolkit.design.palette.VWStepPaletteWrapper;
import filenet.vw.toolkit.design.palette.VWTextAnnotationPaletteItemUI;
import filenet.vw.toolkit.design.palette.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

class VWStepPaletteMenu
extends VWPopupMenu
implements ActionListener {
    private JMenuItem m_openPaletteWindowMenuItem = null;
    private Vector m_paletteMenuItems = null;
    private JMenu m_myPaletteMenu = null;
    private JMenuItem m_deleteMenuItem = null;
    private JMenuItem m_newMenuItem = null;
    private JMenuItem m_openMenuItem = null;
    private JMenuItem m_closeMenuItem = null;
    private JMenuItem m_saveMenuItem = null;
    private JMenuItem m_saveAsMenuItem = null;
    private JMenu m_fileNetMenu = null;
    private JMenuItem m_fnOpenMenuItem = null;
    private JMenuItem m_fnAddMenuItem = null;
    private JMenuItem m_fnCheckInMenuItem = null;
    private JMenuItem m_fnCancelCheckOutMenuItem = null;
    private JMenuItem m_fnSaveMenuItem = null;
    private JMenuItem m_helpMenuItem = null;
    private VWStepPalettePanel m_stepPalettePanel = null;
    private VWDraggablePaletteItemUI m_selectedUIItem = null;

    public VWStepPaletteMenu(VWStepPalettePanel stepPalettePanel) {
        this.m_stepPalettePanel = stepPalettePanel;
        this.createMenuItems();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_openPaletteWindowMenuItem)) {
            this.m_stepPalettePanel.displayStepPaletteDialog();
        } else if (source instanceof VWPaletteMenuItem) {
            VWStepPaletteWrapper stepPaletteWrapper;
            if (!((VWPaletteMenuItem)source).isSelected() && VWStringUtils.compare((stepPaletteWrapper = ((VWPaletteMenuItem)source).getStepPaletteWrapper()).getResourceName(), VWResource.s_myPaletteOption) == 0) {
                this.m_stepPalettePanel.setSelectedUIItem(null);
            }
            this.m_stepPalettePanel.handleStepPaletteSelectionAction();
        } else if (source.equals(this.m_helpMenuItem)) {
            this.performHelpItemAction();
        } else {
            VWStepPaletteDocumentHelper documentHelper = this.m_stepPalettePanel.getStepPaletteDocumentHelper();
            VWStepPaletteWrapper myPaletteWrapper = this.findStepPalette(VWResource.s_myPaletteOption);
            if (source.equals(this.m_deleteMenuItem)) {
                this.m_stepPalettePanel.performDeleteItemAction();
            } else if (source.equals(this.m_newMenuItem)) {
                documentHelper.performNewItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_openMenuItem)) {
                documentHelper.performOpenItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_closeMenuItem)) {
                documentHelper.performNewItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_saveMenuItem)) {
                documentHelper.performSaveItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_saveAsMenuItem)) {
                documentHelper.performSaveAsItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_fnOpenMenuItem)) {
                documentHelper.performFnOpenItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_fnAddMenuItem)) {
                documentHelper.performFnAddItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_fnCheckInMenuItem)) {
                documentHelper.performFnCheckInItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_fnCancelCheckOutMenuItem)) {
                documentHelper.performFnCancelCheckOutItemAction(myPaletteWrapper);
            } else if (source.equals(this.m_fnSaveMenuItem)) {
                documentHelper.performFnSaveItemAction(myPaletteWrapper);
            }
            this.updateMenuStates(myPaletteWrapper);
        }
    }

    protected VWStepPaletteWrapper[] getSelectedStepPalettes() {
        if (this.m_paletteMenuItems == null) {
            return null;
        }
        Vector<VWStepPaletteWrapper> selectedItems = new Vector<VWStepPaletteWrapper>();
        for (int nIndex = 0; nIndex < this.m_paletteMenuItems.size(); ++nIndex) {
            VWPaletteMenuItem menuItem = (VWPaletteMenuItem)this.m_paletteMenuItems.elementAt(nIndex);
            if (!menuItem.isSelected()) continue;
            selectedItems.addElement(menuItem.getStepPaletteWrapper());
        }
        if (selectedItems.size() > 0) {
            Object[] selectedStepPalettes = new VWStepPaletteWrapper[selectedItems.size()];
            selectedItems.copyInto(selectedStepPalettes);
            return selectedStepPalettes;
        }
        return null;
    }

    protected VWStepPaletteWrapper findStepPalette(String paletteName) {
        if (this.m_paletteMenuItems == null) {
            return null;
        }
        for (int nIndex = 0; nIndex < this.m_paletteMenuItems.size(); ++nIndex) {
            VWPaletteMenuItem menuItem = (VWPaletteMenuItem)this.m_paletteMenuItems.elementAt(nIndex);
            VWStepPaletteWrapper vwStepPaletteWrapper = menuItem.getStepPaletteWrapper();
            if (VWStringUtils.compare(vwStepPaletteWrapper.getName(), paletteName) != 0) continue;
            return vwStepPaletteWrapper;
        }
        return null;
    }

    protected boolean updateStepPaletteMenuItem(VWStepPaletteWrapper newStepPaletteWrapper) {
        if (this.m_paletteMenuItems == null) {
            return false;
        }
        for (int nIndex = 0; nIndex < this.m_paletteMenuItems.size(); ++nIndex) {
            VWPaletteMenuItem menuItem = (VWPaletteMenuItem)this.m_paletteMenuItems.elementAt(nIndex);
            VWStepPaletteWrapper vwStepPaletteWrapper = menuItem.getStepPaletteWrapper();
            if (VWStringUtils.compare(vwStepPaletteWrapper.getName(), newStepPaletteWrapper.getName()) != 0) continue;
            menuItem.setStepPaletteWrapper(newStepPaletteWrapper);
            menuItem.setSelected(true);
            return true;
        }
        return false;
    }

    protected VWDraggablePaletteItemUI getSelectedUIItem() {
        return this.m_selectedUIItem;
    }

    protected void setSelectedUIItem(VWDraggablePaletteItemUI newSelectedUIItem) {
        this.m_deleteMenuItem.setEnabled(false);
        this.m_selectedUIItem = newSelectedUIItem;
        if (newSelectedUIItem == null || newSelectedUIItem instanceof VWTextAnnotationPaletteItemUI) {
            return;
        }
        if (newSelectedUIItem instanceof VWStepPaletteItemUI) {
            VWStepPaletteWrapper vwStepPaletteWrapper = ((VWStepPaletteItemUI)newSelectedUIItem).getStepPaletteWrapper();
            this.m_deleteMenuItem.setEnabled(vwStepPaletteWrapper.isEditable());
        }
    }

    protected void releaseReferences() {
        if (this.m_openPaletteWindowMenuItem != null) {
            this.m_openPaletteWindowMenuItem.removeActionListener(this);
            this.m_openPaletteWindowMenuItem = null;
        }
        if (this.m_paletteMenuItems != null) {
            for (int nIndex = 0; nIndex < this.m_paletteMenuItems.size(); ++nIndex) {
                VWPaletteMenuItem menuItem = (VWPaletteMenuItem)this.m_paletteMenuItems.elementAt(nIndex);
                menuItem.removeActionListener(this);
            }
            this.m_paletteMenuItems.removeAllElements();
            this.m_paletteMenuItems = null;
        }
        if (this.m_myPaletteMenu != null) {
            Component[] items = this.m_myPaletteMenu.getMenuComponents();
            if (items != null) {
                for (int nIndex = 0; nIndex < items.length; ++nIndex) {
                    if (!(items[nIndex] instanceof JMenuItem)) continue;
                    ((JMenuItem)items[nIndex]).removeActionListener(this);
                }
            }
            this.m_myPaletteMenu.removeAll();
            this.m_myPaletteMenu = null;
        }
        this.m_deleteMenuItem = null;
        this.m_newMenuItem = null;
        this.m_openMenuItem = null;
        this.m_closeMenuItem = null;
        this.m_saveMenuItem = null;
        this.m_saveAsMenuItem = null;
        if (this.m_fileNetMenu != null) {
            Component[] items = this.m_fileNetMenu.getMenuComponents();
            if (items != null) {
                for (int nIndex = 0; nIndex < items.length; ++nIndex) {
                    if (!(items[nIndex] instanceof JMenuItem)) continue;
                    ((JMenuItem)items[nIndex]).removeActionListener(this);
                }
            }
            this.m_fileNetMenu.removeAll();
            this.m_fileNetMenu = null;
        }
        this.m_fnOpenMenuItem = null;
        this.m_fnAddMenuItem = null;
        this.m_fnCheckInMenuItem = null;
        this.m_fnCancelCheckOutMenuItem = null;
        this.m_fnSaveMenuItem = null;
        if (this.m_helpMenuItem != null) {
            this.m_helpMenuItem.removeActionListener(this);
            this.m_helpMenuItem = null;
        }
        this.m_stepPalettePanel = null;
        this.m_selectedUIItem = null;
        this.removeAll();
    }

    private void createMenuItems() {
        this.m_openPaletteWindowMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuOpenPaletteWindow_withHK);
        if (this.m_openPaletteWindowMenuItem != null) {
            this.m_openPaletteWindowMenuItem.addActionListener(this);
            this.add(this.m_openPaletteWindowMenuItem);
        }
        this.add(new JSeparator());
        VWStepPaletteWrapper myPaletteWrapper = this.loadPalettes();
        this.add(new JSeparator());
        this.createMyPaletteMenu();
        if (myPaletteWrapper != null) {
            this.updateMenuStates(myPaletteWrapper);
        }
        this.add(new JSeparator());
        this.m_helpMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuHelp_withHK);
        if (this.m_helpMenuItem != null) {
            this.m_helpMenuItem.addActionListener(this);
            this.add(this.m_helpMenuItem);
        }
    }

    private VWStepPaletteWrapper loadPalettes() {
        try {
            this.m_paletteMenuItems = new Vector();
            VWStepPaletteDocumentHelper documentHelper = this.m_stepPalettePanel.getStepPaletteDocumentHelper();
            if (documentHelper == null) {
                return null;
            }
            VWStepPaletteWrapper myPaletteWrapper = null;
            VWStepPaletteWrapper[] stepPalettes = documentHelper.getStepPalettes();
            if (stepPalettes != null) {
                String[] selectedResourceNames = documentHelper.getSelectedStepPaletteResourceNames();
                for (int nIndex = 0; nIndex < stepPalettes.length; ++nIndex) {
                    String filePath;
                    VWPaletteMenuItem newMenuItem = new VWPaletteMenuItem(stepPalettes[nIndex]);
                    newMenuItem.addActionListener(this);
                    this.m_paletteMenuItems.add(newMenuItem);
                    this.add(newMenuItem);
                    if (selectedResourceNames != null) {
                        for (int nResourceIndex = 0; nResourceIndex < selectedResourceNames.length; ++nResourceIndex) {
                            if (VWStringUtils.compare(stepPalettes[nIndex].getResourceName(), selectedResourceNames[nResourceIndex]) != 0) continue;
                            newMenuItem.setSelected(true);
                            break;
                        }
                    }
                    if (stepPalettes[nIndex].getType() != 1 || (filePath = stepPalettes[nIndex].getFileNameToolTip()) == null || filePath.length() <= 0) continue;
                    myPaletteWrapper = stepPalettes[nIndex];
                }
            }
            return myPaletteWrapper;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void createMyPaletteMenu() {
        this.m_myPaletteMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuMyPalette_withHK);
        if (this.m_myPaletteMenu != null) {
            this.add(this.m_myPaletteMenu);
        }
        this.m_deleteMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuDeleteFromMyPalette_withHK);
        if (this.m_deleteMenuItem != null) {
            this.m_deleteMenuItem.addActionListener(this);
            this.m_deleteMenuItem.setEnabled(false);
            this.m_myPaletteMenu.add(this.m_deleteMenuItem);
        }
        this.m_myPaletteMenu.add(new JSeparator());
        int nMenuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.m_newMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuNewPalette_withHK);
        if (this.m_newMenuItem != null) {
            this.m_newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, nMenuShortcutKeyMask));
            this.m_newMenuItem.addActionListener(this);
            this.m_myPaletteMenu.add(this.m_newMenuItem);
        }
        this.m_openMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuOpen_withHK);
        if (this.m_openMenuItem != null) {
            this.m_openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, nMenuShortcutKeyMask));
            this.m_openMenuItem.addActionListener(this);
            this.m_myPaletteMenu.add(this.m_openMenuItem);
        }
        this.m_closeMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuClose_withHK);
        if (this.m_closeMenuItem != null) {
            this.m_closeMenuItem.addActionListener(this);
            this.m_myPaletteMenu.add(this.m_closeMenuItem);
        }
        this.m_myPaletteMenu.add(new JSeparator());
        this.m_saveMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSave_withHK);
        if (this.m_saveMenuItem != null) {
            this.m_saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, nMenuShortcutKeyMask));
            this.m_saveMenuItem.addActionListener(this);
            this.m_myPaletteMenu.add(this.m_saveMenuItem);
        }
        this.m_saveAsMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSaveAs_withHK);
        if (this.m_saveAsMenuItem != null) {
            this.m_saveAsMenuItem.addActionListener(this);
            this.m_myPaletteMenu.add(this.m_saveAsMenuItem);
        }
        if (this.m_stepPalettePanel.getAuthPropertyData().getSessionInfo().getCanSaveToDMS()) {
            this.m_myPaletteMenu.add(new JSeparator());
            this.m_fileNetMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuFileNet_withHK);
            if (this.m_fileNetMenu != null) {
                this.m_fnOpenMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnOpen_withHK);
                if (this.m_fnOpenMenuItem != null) {
                    this.m_fnOpenMenuItem.addActionListener(this);
                    this.m_fileNetMenu.add(this.m_fnOpenMenuItem);
                }
                this.m_fnAddMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnAdd_withHK);
                if (this.m_fnAddMenuItem != null) {
                    this.m_fnAddMenuItem.addActionListener(this);
                    this.m_fileNetMenu.add(this.m_fnAddMenuItem);
                }
                this.m_fnCheckInMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnCheckin_withHK);
                if (this.m_fnCheckInMenuItem != null) {
                    this.m_fnCheckInMenuItem.addActionListener(this);
                    this.m_fnCheckInMenuItem.setEnabled(false);
                    this.m_fileNetMenu.add(this.m_fnCheckInMenuItem);
                }
                this.m_fnCancelCheckOutMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnCancelCheckout_withHK);
                if (this.m_fnCancelCheckOutMenuItem != null) {
                    this.m_fnCancelCheckOutMenuItem.addActionListener(this);
                    this.m_fnCancelCheckOutMenuItem.setEnabled(false);
                    this.m_fileNetMenu.add(this.m_fnCancelCheckOutMenuItem);
                }
                this.m_fnSaveMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuFnSave_withHK);
                if (this.m_fnSaveMenuItem != null) {
                    this.m_fnSaveMenuItem.addActionListener(this);
                    this.m_fnSaveMenuItem.setEnabled(false);
                    this.m_fileNetMenu.add(this.m_fnSaveMenuItem);
                }
                this.m_myPaletteMenu.add(this.m_fileNetMenu);
            }
        }
    }

    private void updateMenuStates(VWStepPaletteWrapper stepPaletteWrapper) {
        if (this.m_stepPalettePanel.getAuthPropertyData().getSessionInfo().getCanSaveToDMS()) {
            this.m_fnCheckInMenuItem.setEnabled(stepPaletteWrapper.isCheckedOut());
            this.m_fnCancelCheckOutMenuItem.setEnabled(stepPaletteWrapper.isCheckedOut());
            this.m_fnSaveMenuItem.setEnabled(stepPaletteWrapper.isCheckedOut());
        }
    }

    private void performHelpItemAction() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh055.htm");
    }
}

